--  (GRUPPO NAVALE ITALIANO C550 CAVOUR by Eric et Patrick Cuesta and Markindel}
-- mount_vfs_texture_path  (current_mod_path.."/Textures/Carrier_NAS.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/Cavour.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/Harrier.zip")
mount_vfs_texture_path  (current_mod_path.."/Textures/")
mount_vfs_model_path	(current_mod_path.."/Shapes")
--mount_vfs_texture_path  (current_mod_path.."/Textures/Horizon_Class_AndreaDoria.zip")
--mount_vfs_texture_path  (current_mod_path.."/Textures/Textures_Fremm.zip")
--mount_vfs_texture_path  (current_mod_path.."/Textures/Textures_USNS_Patuntex.zip")





GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "C550_Cavour"
GT.visual.shape_dstr = ""
GT.animation_arguments.radar1_rotation = 11; -- вращение радара 1

GT.animation_arguments.luna_lights = 100;

GT.life = 7000;
GT.mass = 7.2916e+007;
GT.max_velocity = 15.4333;
GT.race_velocity = 15.4333;
GT.economy_velocity = 15.4333;
GT.economy_distance = 7.408e+007;
GT.race_distance = 7.408e+007;
GT.shipLength = 332.9;
GT.Width = 32;
GT.Height = 57.8;
GT.Length = 332.9;
GT.DeckLevel = 20.824;
GT.X_nose = 123.7;
GT.X_tail = -90.6;
GT.Tail_Width = 25;
GT.Gamma_max = 0.35;
GT.Om = 0.05;
GT.speedup = 0.119249;
GT.R_min = 665.8;
GT.distFindObstacles = 1048.7;

GT.numParking = 4;
GT.Plane_Num_ = 72;
GT.Helicopter_Num_ = 6;

GT.airWeaponDist = 12000;
GT.airFindDist = 25000;

GT.exhaust = {
	[1] = { size = 0.02 , pos = { -14.838, 35.823, 18.787 } },
	[2] = { size = 0.02 , pos = { 24.204, 35.823, 18.787 } },
	[3] = { size = 0.02 , pos = { -10.838, 35.823, 18.787 } },
	[4] = { size = 0.052, pos = { 28.204, 35.823, 18.787 } },
}

--GT.ArrestingGears = {
	--{
		--Left = {	pos = {-110.701,  19.874, -17.033} },
		--Right = {	pos = {-105.19,   19.874, 17.574} }
	--},
	--{
		--Left = {	pos = {-98.849,   19.874, -19.022} },
		--Right = {	pos = {-93.338,   19.874, 15.585} }
	--},
	--{
		--Left = {	pos = {-86.718,   19.874, -20.494} },
		--Right = {	pos = {-81.207,   19.874, 14.113} }
	--},
	--{
		--Left = {	pos = {-74.601,   19.874, -22.845} },
		--Right = {	pos = {-69.09,    19.874, 11.762} }
	--}
--}
--GT.ArrestingGears.ArrestingGearsNumber = #GT.ArrestingGears


GT.Landing_Point = {-65.0, 20.824, -12.0}
GT.LSOView = {cockpit = "empty", position = {--[[connector = "",]] offset = {-14.0, 19.7, -16.0, -171.0, 4.0}}}


GT.WS = {}
GT.WS.maxTargetDetectionRange = 30000;
GT.WS.radar_type = 104
GT.WS.searchRadarMaxElevation = math.rad(50);

local ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles_mech = {
							{math.rad(95), math.rad(-95), math.rad(-5), math.rad(90)}
}
GT.WS[ws].angles[1][1] = math.rad(70);
GT.WS[ws].angles[1][2] = math.rad(-95);
GT.WS[ws].angles[2] = {math.rad(95), math.rad(70), math.rad(10), math.rad(85)};
GT.WS[ws].board = 3
GT.WS[ws].pos = {101.963,17.463,-21.153}
--GT.WS[ws].drawArgument1 = 23
--GT.WS[ws].drawArgument2 = 24

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles_mech = {
							{math.rad(85), math.rad(-70), math.rad(-5), math.rad(90)}
}
GT.WS[ws].angles[1][1] = math.rad(85);
GT.WS[ws].angles[1][2] = math.rad(-45);
GT.WS[ws].angles[2] = {math.rad(-45), math.rad(-70), math.rad(10), math.rad(85)};
GT.WS[ws].board = 4
GT.WS[ws].pos = {90.953,16.097,23.294}
--GT.WS[ws].drawArgument1 = 25
--GT.WS[ws].drawArgument2 = 26

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles[1][1] = math.rad(100);
GT.WS[ws].angles[1][2] = math.rad(-100);
GT.WS[ws].board = 2
GT.WS[ws].pos = {-163.792,10.061,14.483}
--GT.WS[ws].drawArgument1 = 29
--GT.WS[ws].drawArgument2 = 30

ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].angles[1][1] = math.rad(95);
GT.WS[ws].angles[1][2] =  math.rad(-70);
GT.WS[ws].board = 3
GT.WS[ws].pos = {-158.042,10.061,-17.74}
--GT.WS[ws].drawArgument1 = 27
--GT.WS[ws].drawArgument2 = 28

--forward
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow )
GT.WS[ws].newZ = false;
GT.WS[ws].pos = {98.225,17.196,21.628}
GT.WS[ws].angles_mech = {
							{math.rad(180), math.rad(-180), math.rad(-5), math.rad(95)}
}
GT.WS[ws].angles[1][1] = math.rad(10);
GT.WS[ws].angles[1][2] = math.rad(-120);
GT.WS[ws].angles[2] = {math.rad(-120), math.rad(10), math.rad(40), 1.48353};
GT.WS[ws].drawArgument1 = 21
GT.WS[ws].drawArgument2 = 22
GT.WS[ws].LN[1].min_launch_angle = math.rad(15);

--back left
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow )
GT.WS[ws].board = 3
GT.WS[ws].pos = {-151.36,18.035,-18.969}
GT.WS[ws].newZ = false;
GT.WS[ws].angles_mech = {
							{math.rad(90), math.rad(-90), math.rad(-5), math.rad(95)}
}
GT.WS[ws].angles[1][1] = math.rad(90);
GT.WS[ws].angles[1][2] = math.rad(-65);
GT.WS[ws].angles[2] = {math.rad(-65), math.rad(-90), math.rad(20), 1.48353};
GT.WS[ws].drawArgument1 = 17
GT.WS[ws].drawArgument2 = 18
GT.WS[ws].LN[1].min_launch_angle = math.rad(15);

--back right
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.seasparrow )
GT.WS[ws].board = 4
GT.WS[ws].pos = {-151.36,18.035,25.376}
GT.WS[ws].newZ = false;
GT.WS[ws].angles_mech = {
							{math.rad(90), math.rad(-90), math.rad(-5), math.rad(95)}
}
GT.WS[ws].angles[1][1] = math.rad(70);
GT.WS[ws].angles[1][2] = math.rad(-90);
GT.WS[ws].drawArgument1 = 19
GT.WS[ws].drawArgument2 = 20
GT.WS[ws].LN[1].min_launch_angle = math.rad(15);

GT.Name			= "Cavour"
GT.DisplayName	= _("C550-Cavour")
GT.Rate			= 5500.000000

GT.Sensors		= {
	OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR","generic tank daysight",},
	RADAR = {
		"Patriot str",
		"ticonderoga search radar",
	},
};

GT.TACAN			= true;
GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000065";

GT.attribute		= {
	wsType_Navy,wsType_Ship,wsType_AirCarrier,
---GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,
	"Aircraft Carriers",
	"cord",
	"ski_jump",
	"RADAR_BAND1_FOR_ARM",
};

GT.Categories = {
	{name = "AircraftCarrier"},
	{name = "Armed Ship"},
};


add_surface_unit(GT)

GT.RunWays =
{     
-- landing strip definition (first in table)
--	VppStartPoint; 					azimuth (degree} 	Length_Vpp; 	Width_Vpp;
	{{-44.54,	20.824, -6.4}, 		360, 			250.0, 			36.0, 		
-- alsArgument, lowGlidePath, slightlyLowGlidePath, onLowerGlidePath, onUpperGlidePath, slightlyHighGlidePath, highGlidePath
	0, 			2.5, 		  		2.8, 					3.0, 			  3.0, 				3.2, 				3.5},
-- runways
	{{-25,	20.824, -12.0}, 		360, 			250, 			36.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
	{{-45,	20.824, -12.0}, 		360, 			250, 			36.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
	{{-65,	20.824, -12.0}, 		360, 			250, 			36.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
	{{-85,	20.824, -12.0}, 		360, 			250, 			36.0, 		0, 2.5, 2.8, 3.0, 3.0, 3.2, 3.5},
};
GT.RunWays.RunwaysNumber = #GT.RunWays

GT.TaxiRoutes = 
	-- taxi routes and parking spots in LCS
	--    x				y        z			V_target
{					
	{ -- 1 parking spot
		{{49.122, 	20.824,		00.54},		3.0},
		{{68.364,	    20.824,		00.54},		2.0},
		{{102.583,	    20.824,		9.54},		2.0}
	},
	{ -- 2 parking spot
		{{49.122,	20.824,		 00.54},	3.0},
		{{68.364,	20.824,		 0.54},	2.0},
		{{86.583,	20.824,		 9.54},	2.0}
      },	 
	{ -- 3 parking spot
		{{49.122, 	20.824,		00.54},		3.0},
		{{68.364,	    20.824,		00.54},		2.0},
		{{70.583,	    20.824,		9.54},		2.0}
		
	};
}
GT.TaxiRoutes.RoutesNumber = #GT.TaxiRoutes